/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.datapack;

import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.datapack.DynamicDatapacks;
import io.github.noeppi_noeppi.libx.impl.datapack.LibXDatapack;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;

public class DynamicDatapackLocator
implements RepositorySource {
    private static final DynamicDatapackLocator INSTANCE = new DynamicDatapackLocator();
    private static final Map<ResourceLocation, DynamicDatapacks.PackFactory> enabledPacks = new HashMap<ResourceLocation, DynamicDatapacks.PackFactory>();

    private DynamicDatapackLocator() {
    }

    public static void locatePacks(AddPackFindersEvent event) {
        event.addRepositorySource((RepositorySource)INSTANCE);
    }

    public static synchronized void enablePack(ResourceLocation id, @Nullable DynamicDatapacks.PackFactory pack) {
        enabledPacks.put(id, pack == null ? LibXDatapack::new : pack);
    }

    public static synchronized boolean isEnabled(ResourceLocation id) {
        return enabledPacks.containsKey(id);
    }

    public void m_7686_(@Nonnull Consumer<Pack> packs, @Nonnull Pack.PackConstructor factory) {
        for (Map.Entry<ResourceLocation, DynamicDatapacks.PackFactory> entry : enabledPacks.entrySet()) {
            ResourceLocation id = entry.getKey();
            DynamicDatapacks.PackFactory packFactory = entry.getValue();
            String name = "libxdata/" + id.m_135827_() + ":" + id.m_135815_();
            IModFileInfo fileInfo = ModList.get().getModFileById(id.m_135827_());
            if (fileInfo == null || fileInfo.getFile() == null) {
                LibX.logger.warn("Can't create dynamic datapack " + id + ": Invalid mod file: " + fileInfo);
                continue;
            }
            Pack pack = Pack.m_10430_((String)name, (boolean)false, () -> packFactory.create(fileInfo.getFile(), id.m_135815_()), (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (pack == null) continue;
            packs.accept(pack);
        }
    }
}

